/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CurseLootFunction
extends LootItemConditionalFunction {
    private static final List<Enchantment> CURSES = ForgeRegistries.ENCHANTMENTS.getEntries().stream().filter(e -> ((Enchantment)e.getValue()).m_6589_()).map(Map.Entry::getValue).collect(Collectors.toList());
    final double chance;

    CurseLootFunction(LootItemCondition[] pConditions, double chance) {
        super(pConditions);
        this.chance = chance;
    }

    public LootItemFunctionType m_7162_() {
        return ModRegistry.CURSE_LOOT_FUNCTION;
    }

    public ItemStack m_7372_(ItemStack pStack, LootContext pContext) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)pStack);
        Random random = pContext.m_78933_();
        if ((double)random.nextFloat() < this.chance) {
            if (CURSES.stream().noneMatch(map::containsKey)) {
                Enchantment e = CURSES.get(random.nextInt(CURSES.size()));
                map.put(e, 1);
            }
        }
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)pStack);
        return pStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CurseLootFunction> {
        public void serialize(JsonObject jsonObject, CurseLootFunction function, JsonSerializationContext context) {
            super.m_6170_(jsonObject, (LootItemConditionalFunction)function, context);
            jsonObject.addProperty("chance", (Number)function.chance);
        }

        public CurseLootFunction deserialize(JsonObject pObject, JsonDeserializationContext context, LootItemCondition[] pConditions) {
            double chance = GsonHelper.m_144742_((JsonObject)pObject, (String)"chance", (double)1.0);
            return new CurseLootFunction(pConditions, chance);
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final double chance;

        public Builder() {
            this(1.0);
        }

        public Builder(double chance) {
            this.chance = chance;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new CurseLootFunction(this.m_80699_(), this.chance);
        }
    }
}

